<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormRegister()
  ===================================================*/

  function ShowFormRegister() {

    // vars global configuration
    global $theme_path;

    // vars template
    global $error_msg;

    DisplayTemplate($theme_path . "register_form.html", "\$error_msg,\$username,\$password,\$password2,\$email");
  }


  /*===================================================
    ProcessFormRegister()
  ===================================================*/

  function ProcessFormRegister() {

    // vars global configuration
    global $dbConn, $enable_user_validation, $theme_path, $email_address;

    // vars url & form
    global $username, $password, $password2, $email;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    // verify input

    if ($_POST[captcha_key] != $_SESSION['captcha_key'])
      $error_msg = $msg["10083"];
    elseif (empty($username))
      $error_msg = $msg["10071"];
    elseif (strlen($username) < 3)
      $error_msg = $msg["10072"];
    elseif (empty($password))
      $error_msg = $msg["10073"];
    elseif (empty($password2))
      $error_msg = $msg["10074"];
    elseif ($password != $password2)
      $error_msg = $msg["10075"];
    elseif (empty($email))
      $error_msg = $msg["10076"];
    elseif (!IsEmailAddress($email))
      $error_msg = $msg["10077"];
    elseif (!IsAlphanumeric($username))
      $error_msg = $msg["10080"];

    if (empty($error_msg)) {

      // register user
      $users_obj = new clsUsers;
      $users_obj->table_name                     = "idx_users";
      $users_obj->enable_user_validation         = $enable_user_validation;
      $users_obj->email_register_subject         = $msg["10081"];
      $users_obj->email_register_from            = $email_address;
      if ($enable_user_validation) {
        $users_obj->email_register_template_file = $theme_path . "mail/register_confirm.mail";
      }
      else {
        $users_obj->email_register_template_file = $theme_path . "mail/register_ok.mail";
      }
      $auth                                      = new auth();
      $register                                  = $users_obj->Register($username, $email, $auth->Convert($password), $password);

      if ($register == '1') {
        $error_msg = $msg["10078"];
        ShowFormRegister();
      }
      else {
        if ($enable_user_validation) {
          DisplayTemplate($theme_path . "register_confirm.html");
        }
        else {
          DisplayTemplate($theme_path . "register_ok.html");
        }
      }
    }
    else {
      ShowFormRegister();
    }
  }


  /*===================================================
    ConfirmRegister()
  ===================================================*/

  function ConfirmRegister() {

    // vars global configuration
    global $dbConn, $enable_user_validation, $theme_path;

    // vars url & form
    global $u, $v;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    $users_obj = new clsUsers;
    $users_obj->table_name = "idx_users";
    $confirm               = $users_obj->ConfirmRegister($u, $v);

    if ($confirm == 0) {
      DisplayTemplate($theme_path . "register_ok.html");
    }
    else {
      DisplayTemplate($theme_path . "register_confirm_error.html");
    }
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  RunPreFilter(__FILE__);

  if (empty($pflag)) {
    ShowFormRegister();
  }
  elseif ($pflag == 'register') {
    ProcessFormRegister();
  }
  elseif ($pflag == 'cf') {
    ConfirmRegister();
  }

  RunPostFilter(__FILE__);

?>